%------------------------------------------------------------------------------
% File     : SEU826^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Set Theory
% Problem  : About sets 1
% Version  : Especial.
% English  :

% Refs     : [BB05]  Benzmueller & Brown (2005), A Structured Set of Higher
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
% Source   : [Ben09]
% Names    : Example 22a [BB05]

% Status   : Theorem
% Rating   : 0.14 v7.4.0, 0.00 v6.2.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v4.1.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :   10 (   0 unit;   6 type;   3 defn)
%            Number of atoms       :   31 (   3 equality;  12 variable)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   21 (   0   ~;   1   |;   1   &;  18   @)
%                                         (   1 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   23 (  23   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    8 (   6   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   1   !;   0   ?;   8   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(seteq_type,type,(
    seteq: ( $i > $o ) > ( $i > $o ) > $o )).

thf(seteq,definition,
    ( seteq
    = ( ^ [X: $i > $o,Y: $i > $o] :
        ! [U: $i] :
          ( ( X @ U )
        <=> ( Y @ U ) ) ) )).

thf(u_type,type,(
    u: ( $i > $o ) > ( $i > $o ) > $i > $o )).

thf(u,definition,
    ( u
    = ( ^ [X: $i > $o,Y: $i > $o,U: $i] :
          ( ( X @ U )
          | ( Y @ U ) ) ) )).

thf(n_type,type,(
    n: ( $i > $o ) > ( $i > $o ) > $i > $o )).

thf(n,definition,
    ( n
    = ( ^ [X: $i > $o,Y: $i > $o,U: $i] :
          ( ( X @ U )
          & ( Y @ U ) ) ) )).

thf(a_type,type,(
    a: $i > $o )).

thf(b_type,type,(
    b: $i > $o )).

thf(c_type,type,(
    c: $i > $o )).

thf(conj,conjecture,
    ( seteq @ ( u @ a @ ( n @ b @ c ) ) @ ( n @ ( u @ a @ b ) @ ( u @ a @ c ) ) )).

%------------------------------------------------------------------------------
